local t = Def.ActorFrame {};
local curScreen = Var "LoadingScreen";
local curStage = GAMESTATE:GetCurrentStage();
local curStageIndex = GAMESTATE:GetCurrentStageIndex();

t[#t+1] = LoadFont("_sansserifflf 32px") .. {
		InitCommand=function(self)
			self:horizalign(left):x(SCREEN_LEFT+75):y(SCREEN_TOP+54):zoom(0.5):maxwidth(250/0.5):diffuse(color("#79A8EA"))
		end;
		BeginCommand=function(self)
			self:diffusealpha(0):decelerate(0.3):diffusealpha(1)
		end;	
		OffCommand=function(self)
			self:decelerate(0.3):diffusealpha(0)
		end;
        SortOrderChangedMessageCommand=function(self) self:playcommand("Set") end;
        ChangedLanguageDisplayMessageCommand=function(self) self:playcommand("Set") end;
        SetCommand=function(self)
               if GAMESTATE:GetSortOrder() then
					self:finishtweening();
                    self:settext(ToUpper(SortOrderToLocalizedString(GAMESTATE:GetSortOrder())));
                    self:playcommand("Refresh");
				else
					self:settext("");
					self:playcommand("Refresh");
               end
        end;
};

t[#t+1] = LoadFont("_sansserifflf 32px") .. {
		InitCommand=function(self)
			self:horizalign(left):x(SCREEN_LEFT+30):y(SCREEN_TOP+54):zoom(0.5):diffuse(color("#A4C3EE"))
		end;
		BeginCommand=function(self)
			self:queuecommand("Set")
			self:diffusealpha(0):decelerate(0.3):diffusealpha(1)
		end;	
		OffCommand=function(self)
			self:decelerate(0.3):diffusealpha(0)
		end;
        SetCommand=function(self)
			self:settext("SORT:")
		end;
};

if not GAMESTATE:IsCourseMode() then
t[#t+1] = LoadFont("_sansserifflf 32px") .. {
	InitCommand=function(self)
		self:horizalign(left):x(SCREEN_RIGHT-180):y(SCREEN_TOP+24):zoom(0.5):diffuse(color("#CBDDF0"))
	end;
	BeginCommand=function(self)
		if SCREENMAN:GetTopScreen() then
			if not string.find(SCREENMAN:GetTopScreen():GetName(),"ScreenEvaluation") then
				curStageIndex = curStageIndex + 1
			end
		end
		self:playcommand("Set")
		self:diffusealpha(0):decelerate(0.3):diffusealpha(1)
	end;
	SetCommand=function(self)
		if GAMESTATE:GetCurrentCourse() then
			self:settext( curStageIndex+1 .. " / " .. GAMESTATE:GetCurrentCourse():GetEstimatedNumStages() );
		elseif GAMESTATE:IsEventMode() then
			self:settextf("Event Stage");
		else
			self:settextf("%s", ToEnumShortString(curStage) .. " Stage");
		end;
	end;
	OffCommand=function(self)
		self:decelerate(0.3):diffusealpha(0)
	end;
};
end;

t[#t+1] = Def.ActorFrame{
	Def.Quad{
		InitCommand=function(self) self:Center():draworder(160):zoomto(SCREEN_WIDTH,SCREEN_HEIGHT):diffuse(color("#000000")):diffusealpha(0) end;
		ShowPressStartForOptionsCommand=function(self) self:decelerate(0.4):diffusealpha(0.75) end;
		ShowEnteringOptionsCommand=function(self) self:decelerate(0.7):diffusealpha(0) end;
		HidePressStartForOptionsCommand=function(self) self:sleep(0.2):decelerate(0.5):diffusealpha(0) end;
	};	
};

t[#t+1] = StandardDecorationFromFileOptional("SongOptions","SongOptionsText") .. {
	ShowPressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsShowCommand");
	ShowEnteringOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsEnterCommand");
	HidePressStartForOptionsCommand=THEME:GetMetric(Var "LoadingScreen","SongOptionsHideCommand");
};

return t;